/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.logd;

import com.ibm.hwmca.base.logd.CreateEventLogData;
import com.ibm.hwmca.base.logd.EventLogData;
import com.ibm.hwmca.base.logd.EventLogSearchInfo;
import com.ibm.hwmca.base.util.BaseMessageText;
import com.ibm.hwmca.base.util.BaseTextBundle;
import com.ibm.hwmca.fw.log.Log;
import com.ibm.hwmca.fw.tasklet.PanelTasklet;
import com.ibm.hwmca.fw.tasklet.TaskletException;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.MsgType;
import com.ibm.hwmca.fw.util.Trace;

public class EventLogSearch {
    private static final String TRACE_MASKT = "XLOGDSST";
    private static final String TRACE_MASKF = "XLOGDSSF";
    private static final String TRACE_MASKD = "XLOGDSSD";
    private static final int NUMBER_OF_SEARCHABLE_COLUMNS = 2;
    private String _textToSearchFor;
    private String _whatToSearch;
    private int _matchLocation;
    private boolean _matchCase;
    private boolean _searchForward;
    private int _searchIndex;
    private Log[] _logData;
    boolean _isFound = false;
    PanelTasklet _panelTasklet;
    private static final LocalizableText _lSearchTitle = new LocalizableText(BaseTextBundle.getBundleName(), "logd.search.title");

    public EventLogSearch(PanelTasklet panelTasklet, EventLogSearchInfo eventLogSearchInfo, Log[] logData) {
        Trace.trace(TRACE_MASKT, "-> EventLogSearch()");
        this._textToSearchFor = eventLogSearchInfo.getTextToSearchFor();
        this._whatToSearch = eventLogSearchInfo.getWhatToSearch();
        this._matchLocation = eventLogSearchInfo.getMatchLocation();
        this._matchCase = eventLogSearchInfo.isMatchCase();
        this._searchForward = eventLogSearchInfo.isSearchForward();
        this._searchIndex = eventLogSearchInfo.getStartIndex();
        this._logData = logData;
        this._panelTasklet = panelTasklet;
        Trace.trace(TRACE_MASKT, "<- EventLogSearch()");
    }

    public int doSearch() throws TaskletException {
        Trace.trace(TRACE_MASKF, "-> EventLogSearch.doSearch()");
        this._isFound = false;
        if (this._textToSearchFor == null) {
            this.displayMsg("LOGDNTXT", MsgType.INFORMATION_MESSAGE);
            Trace.trace(TRACE_MASKF, "search data is null");
        } else {
            Trace.trace(TRACE_MASKF, "searchTextAsEntered=[" + this._textToSearchFor + "]");
            Trace.trace(TRACE_MASKF, "startIndex=" + this._searchIndex + " matchLocation=" + this._matchLocation + " matchCase=" + this._matchCase + " searchForward=" + this._searchForward);
            if (this._whatToSearch != null) {
                Trace.trace(TRACE_MASKF, "whatToSearch=" + this._whatToSearch);
            } else {
                Trace.trace(TRACE_MASKF, "whatToSearch is null(do All columns");
            }
            this._textToSearchFor = this._textToSearchFor.trim();
            if (this._textToSearchFor.length() == 0) {
                Trace.trace(TRACE_MASKF, "search data len is 0");
                this.displayMsg("LOGDNTXT", MsgType.INFORMATION_MESSAGE);
            } else if (this._whatToSearch != null && !this._whatToSearch.equals("NameCol") && !this._whatToSearch.equals("DataCol")) {
                this.displayMsg("LOGDUOPT", MsgType.INFORMATION_MESSAGE);
                Trace.trace(TRACE_MASKF, "Unsupported matchLocation=[" + this._matchLocation + "]");
            } else {
                if (!this._matchCase) {
                    this._textToSearchFor = this._textToSearchFor.toUpperCase();
                }
                Trace.trace(TRACE_MASKF, "actualSearchText=[" + this._textToSearchFor + "]");
                int numInLog = this._logData.length;
                int numToSearch = this._searchForward ? numInLog - this._searchIndex : this._searchIndex + 1;
                Trace.trace(TRACE_MASKF, "numToSearch=" + numToSearch + " numInLog=" + numInLog);
                this.doTheSearch(numToSearch);
                if (!this._isFound) {
                    this._searchIndex = -1;
                }
                Trace.trace(TRACE_MASKF, "search result: found=" + this._isFound + " foundIndex=" + this._searchIndex);
            }
        }
        Trace.trace(TRACE_MASKF, "<- EventLogSearch.doSearch()");
        return this._searchIndex;
    }

    private void doTheSearch(int numToSearch) throws TaskletException {
        Trace.trace(TRACE_MASKF, "->doTheSearch");
        this._isFound = false;
        String[] str = null;
        str = this._whatToSearch == null ? new String[2] : new String[1];
        EventLogData[] eventLogData = new EventLogData[]{new EventLogData()};
        CreateEventLogData createEventLogData = new CreateEventLogData();
        int numberColumnsToSearch = str.length;
        int i = 0;
        while (i < numToSearch && !this._isFound) {
            Trace.trace(TRACE_MASKD, "count=" + i + " searchIndex=" + this._searchIndex);
            if (this._whatToSearch == null) {
                createEventLogData.createEventLogData(this._logData[this._searchIndex], eventLogData);
                str[0] = eventLogData[0].getName().trim();
                str[1] = eventLogData[0].getData().trim();
            } else if (this._whatToSearch.equals("NameCol")) {
                str[0] = this._logData[this._searchIndex].getEventName().trim();
            } else if (this._whatToSearch.equals("DataCol")) {
                str[0] = this._logData[this._searchIndex].getTowerData().trim();
            }
            int j = 0;
            while (j < numberColumnsToSearch && !this._isFound) {
                if (str[j] != null && str[j].length() != 0) {
                    if (!this._matchCase) {
                        str[j] = str[j].toUpperCase();
                    }
                    Trace.trace(TRACE_MASKF, "search searchTxt=[" + this._textToSearchFor + "]" + " str=[" + str[j] + "]");
                    if (this._matchLocation == 0) {
                        if (str[j].equals(this._textToSearchFor)) {
                            this._isFound = true;
                            Trace.trace(TRACE_MASKF, "Found EXACT match at index=" + this._searchIndex + " colIndex=" + j);
                        }
                    } else if (this._matchLocation == 1) {
                        int index = str[j].indexOf(this._textToSearchFor);
                        if (index != -1) {
                            this._isFound = true;
                            Trace.trace(TRACE_MASKF, "Found CONTAINS match at index=" + this._searchIndex + " indexOf=" + index + " colIndex=" + j);
                        }
                    } else if (this._matchLocation == 2) {
                        if (str[j].startsWith(this._textToSearchFor)) {
                            this._isFound = true;
                            Trace.trace(TRACE_MASKF, "Found STARTS_WITH match at index=" + this._searchIndex + " colIndex=" + j);
                        }
                    } else if (this._matchLocation == 3 && str[j].endsWith(this._textToSearchFor)) {
                        this._isFound = true;
                        Trace.trace(TRACE_MASKF, "Found ENDS_WITH match at index=" + this._searchIndex + " colIndex=" + j);
                    }
                } else {
                    Trace.trace(TRACE_MASKD, "Don't check search str.  index=" + this._searchIndex + " columnIndex=" + j);
                }
                ++j;
            }
            if (!this._isFound) {
                this._searchIndex = this._searchForward ? ++this._searchIndex : --this._searchIndex;
            }
            ++i;
        }
        Trace.trace(TRACE_MASKF, "<- doTheSearch");
    }

    private void displayMsg(String msgKey, MsgType msgType) throws TaskletException {
        LocalizableText lSearchTitle = new LocalizableText(BaseTextBundle.getBundleName(), "logd.search.title");
        BaseMessageText myMess = new BaseMessageText(msgKey);
        this._panelTasklet.showMessageBox(true, lSearchTitle, myMess, msgType, null);
        this._searchIndex = -2;
    }
}

